@php
    if ($settings->redirect_url != null or !empty($settings->redirect_url)) {
        header("Location: $settings->redirect_url", true, 301);
        exit();
    }
@endphp
@extends('layouts.base1')
@inject('content', 'App\Http\Controllers\FrontController')
@section('title', 'About Us')


@section('content')
<main>
            <!-- Breadcum Start -->
            <section class="breadcum v1">
                <div class="container">
                    <div class="breadcum-content">
                        <h2>Contact Us</h2>
                        <ul>
                            <li><a href="index.html">Home</a></li>
                            <li>Contact Us</li>
                        </ul>
                    </div>
                </div>
                <div class="bg-shap-1" data-background="temp/base/assets/img/breadcum/v1/bg-shap.svg"></div>
                <div class="bg-shap-2" data-background="temp/base/assets/img/breadcum/v1/img-1.png"></div>
                <div class="bg-shap-3" data-background="temp/base/assets/img/breadcum/v1/img-2.png"></div>
            </section>
            <!-- Breadcum End -->
            <!-- Contact Start -->
            <section class="contact pt-sm-50 pb-sm-50 pt-md-70 pb-md-70 pt-xl-100 pb-xl-100 pt-130">
                <div class="container bg-cover-center" data-background="temp/base/assets/img/contact/contact-bg.jpg">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="content-left">
                                <div class="section-title v1">
                                    <h6 class="sub-title v13">Contact</h6>
                                    <h2 class="big-title v3">Dont's hesitate to <br> reach out to us </h2>
                                    <p class="title-pera">Don't hesitate to reach out to us. We're always available to assist you with any questions or concerns you may have.</p>
                                </div>
                                <ul class="contact-info">
                                    <li>
                                        <div class="box-icon">
                                            <i class="my-icon icon-massage"></i>
                                        </div>
                                        <h6 class="list-title">{{ $settings->contact_email }}</h6>
                                    </li>
                                    <li>
                                        <div class="box-icon">
                                            <i class="my-icon icon-location-dot-solid"></i>
                                        </div>
                                        <h6 class="list-title">{{ $settings->address }}
                                        </h6>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="contact-form">
                                <form action="#" method="post">
                                    <div class="form-input">
                                        <label for="name">Name:</label>
                                        <input type="text" id="name" name="name" placeholder="Your Name" required>
                                    </div>

                                    <div class="form-input">
                                        <label for="email">Email:</label>
                                        <input type="email" id="email" name="email" placeholder="Work Email" required>
                                    </div>

                                    <div class="form-input">
                                        <label for="company">Company Name:</label>
                                        <input type="text" id="company" placeholder="Company Name" name="company">
                                    </div>

                                    <div class="form-input">
                                        <label for="message">Message:</label>
                                        <textarea id="message" name="message" placeholder="Your Message" rows="4"
                                            required></textarea>
                                    </div>

                                    <div class="form-btn">
                                        <button type="submit">Contact Us</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- Contact End -->
            <!-- Contact Map Start -->
            <section class="contact-map v1">
                <iframe
                    src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d14613.167032861855!2d90.433811!3d23.701273!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3755b767a022cd4b%3A0xaf33907e219d127!2sRayerbag%2C%20Dhaka!5e0!3m2!1sen!2sbd!4v1675146270950!5m2!1sen!2sbd"></iframe>
            </section>
            <!-- Contact Map End -->
            <!-- Our Values Start -->
            <section class="our-values v2 pt-sm-50 pb-sm-50 pt-md-70 pb-md-70 pt-xl-100 pb-xl-100 pt-130 pb-130">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-5">
                            <div class="section-title-white v7">
                                <h2 class="big-title">Interested To Join Our Team?</h2>
                                <p>Explore exciting opportunities, collaborate with passionate professionals, and make an impact with us today.</p>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <ul class="faq-accordion" id="accordionFAQ">
                                <li>
                                    <button type="button" data-bs-toggle="collapse" data-bs-target="#teamwork"> Pay and get paid on your terms</button>
                                    <div id="teamwork" class="collapse show" data-bs-parent="#accordionFAQ">
                                        <div class="box-content">
                                            <h6>Take control of your finances. Pay and get paid on your terms. No more waiting, no more hassle. Empower yourself today.
                                            </h6>
                                        </div>
                                    </div>
                                </li>
                                <li>
                                    <button class="collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#innovation"> Control your customer experience</button>
                                    <div id="innovation" class="collapse" data-bs-parent="#accordionFAQ">
                                        <div class="box-content">
                                            <h6>Own your customer experience. Every interaction matters. From start to finish, ensure excellence, reflect your brand, and foster loyalty.
                                            </h6>
                                        </div>
                                    </div>
                                </li>
                                
                                <li>
                                    <button class="collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#freedom">Expand your book of business</button>
                                    <div id="freedom" class="collapse" data-bs-parent="#accordionFAQ">
                                        <div class="box-content">
                                            <h6>Grow your client base. Reach new markets, seize opportunities, and elevate your business to new heights.
                                            </h6>
                                        </div>
                                    </div>
                                </li>
                                <li>
                                    <button class="collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#integrity">Automate your workflows</button>
                                    <div id="integrity" class="collapse" data-bs-parent="#accordionFAQ">
                                        <div class="box-content">
                                            <h6>Streamline operations. Automate workflows for efficiency, productivity, and peace of mind.
                                            </h6>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </section>
            <!-- Our Values End -->
            <!-- Partners Logo Start -->
            <section class="partners-logo v4 pt-sm-50 pb-sm-50 pt-md-70 pb-md-70 pt-xl-100 pb-xl-100 pt-130 pb-130">
                <div class="container">
                    <div class="partners-logo-main">
                        <h4 class="partners-logo-title">Loved by marketing <br> teams worldwide</h4>
                        <div class="slider">
                            <div class="swiper-wrapper">
                                <div class="swiper-slide">
                                    <a href="#"><img src="temp/base/assets/img/official-partners/v3/logo-1.svg" alt="logo"></a>
                                </div>
                                <div class="swiper-slide">
                                    <a href="#"><img src="temp/base/assets/img/official-partners/v3/logo-2.svg" alt="logo"></a>
                                </div>
                                <div class="swiper-slide">
                                    <a href="#"><img src="temp/base/assets/img/official-partners/v3/logo-3.svg" alt="logo"></a>
                                </div>
                                <div class="swiper-slide">
                                    <a href="#"><img src="temp/base/assets/img/official-partners/v3/logo-4.svg" alt="logo"></a>
                                </div>
                                <div class="swiper-slide">
                                    <a href="#"><img src="temp/base/assets/img/official-partners/v3/logo-5.svg" alt="logo"></a>
                                </div>
                                <div class="swiper-slide">
                                    <a href="#"><img src="temp/base/assets/img/official-partners/v3/logo-6.svg" alt="logo"></a>
                                </div>
                                <div class="swiper-slide">
                                    <a href="#"><img src="temp/base/assets/img/official-partners/v3/logo-1.svg" alt="logo"></a>
                                </div>
                                <div class="swiper-slide">
                                    <a href="#"><img src="temp/base/assets/img/official-partners/v3/logo-2.svg" alt="logo"></a>
                                </div>
                                <div class="swiper-slide">
                                    <a href="#"><img src="temp/base/assets/img/official-partners/v3/logo-3.svg" alt="logo"></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- Partners Logo End -->
        </main>



@endsection
