@extends('layouts.bankapp')
@section('title', $title)
@section('content')
    <!-- App Header -->
    <div class="appHeader">
        <div class="left">
            <a href="{{ route('cancelconfirm') }}" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            Transaction Preview
        </div>
        <div class="right">
            <a onclick="location.reload();" class="headerButton">
                <ion-icon name="refresh"></ion-icon>
            </a>
        </div>
    </div>
    <!-- * App Header -->



    <!-- App Capsule -->
    <div id="appCapsule" class="full-height">

        <div class="section mt-2 mb-2">


            <div class="listed-detail mt-3">
                <div class="icon-wrapper">
                    <div class="iconbox">
                        <ion-icon name="eye"></ion-icon>
                    </div>
                </div>
                <h3 class="text-center mt-2">Preview Transaction</h3>
            </div>

            <ul class="listview flush transparent simple-listview no-space mt-3">
                <li>
                    <strong>To</strong>
                    <span>{{ $confirmdata['accountname'] }}</span>
                </li>
                <li>
                    <strong>Transaction type</strong>
                    <span>{{ $confirmdata['payment_mode'] }}</span>
                </li>
                @if ($confirmdata['payment_mode'] == 'Wire Transfer')
                    <li>
                        <strong>Account Number</strong>
                        <span>{{ $confirmdata['accountnumber'] }}</span>
                    </li>
                @elseif($confirmdata['payment_mode'] == 'Cryptocurrency')
                    <li>
                        <strong>Wallet Address</strong>
                        <span>{{ $confirmdata['accountnumber'] }}</span>
                    </li>
                @elseif($confirmdata['payment_mode'] == 'Western Union')
                    <li>
                        <strong>Name</strong>
                        <span>{{ $confirmdata['accountnumber'] }}</span>
                    </li>
                @else
                    <li>
                        <strong>Email</strong>
                        <span>{{ $confirmdata['accountnumber'] }}</span>
                    </li>
                @endif
                @if ($confirmdata['payment_mode'] == 'Wire Transfer')
                    <li>
                        <strong>Routine Number</strong>
                        <span>{{ $confirmdata['iban'] }}</span>
                    </li>
                @endif
                <li>
                    <strong>Amount</strong>
                    <h3 class="m-0">
                        {{ number_format($confirmdata['amount'], 2, '.', ',') }}{{ Auth::user()->currency }}
                    </h3>
                </li>

                <li>
                    <strong>Refrence ID</strong>
                    <span>#{{ $confirmdata['txn_id'] }}</span>
                </li>
            </ul>


            <br>
            <div class="form-group basic">
                <div class="row">
                    <div class="col-6">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#DialogBasic"
                            class="btn btn-lg btn-danger cancel btn-block">Cancel</a>
                    </div>
                    <div class="col-6">



                        <a class="btn btn-lg btn-primary btn-block" href='{{ route('proceedtranscation') }}'
                            name="inter-preview">Proceed</a>



                    </div>
                </div>
            </div>



        </div>

    </div>
    <!-- * App Capsule -->


    <!-- Dialog Basic -->
    <div class="modal fade dialogbox" id="DialogBasic" data-bs-backdrop="static" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Cancel Transaction</h5>
                </div>
                <div class="modal-body">
                    Are you sure?
                </div>
                <div class="modal-footer">
                    <div class="btn-inline">
                        <a href="#" class="btn btn-text-secondary" data-bs-dismiss="modal">CLOSE</a>
                        <a href="{{ route('cancelconfirm') }}" class="btn btn-text-primary">YES</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- * Dialog Basic -->
@endsection
