@extends('layouts.bankapp')

@section('title', 'Fund Transfer')
@section('content')
    <!-- App Header -->
    <div class="appHeader transparent">
        <div class="left">
            <a href="{{ route('dashboard') }}" class="headerButton">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle"></div>
        <div class="right">
            <a onclick="location.reload();" class="headerButton">
                <ion-icon name="refresh"></ion-icon>
            </a>
        </div>
    </div>
    <!-- * App Header -->

    <!-- App Capsule -->
    <div id="appCapsule">
        <div class="text-center mb-1 mt-1">
            {{-- <a href="/" class="py-9 pt-lg-20">
                <img alt="Logo" src="{{ asset('storage/app/public/' . $settings->logo) }}"
                    style="height:auto; max-width:30%;" />
            </a> --}}
            <x-danger-alert />
            <x-success-alert />
        </div>

        <div class='mt-2'>
            <center> <img src="{{ asset('dash2/app/1.jpg') }}" alt="logo" class="logo"
                    style=" width: 180px; height:112px; border-radius:27px;"></center>
        </div>
        <div class="text-center mb-2 mt-1">
            <h1 class="text-dark mb-3">Enter OTP</h1>
            <div class="text-gray-600 fw-bold fs-4">Input the OTP we sent to {{ Auth::user()->email }}</div>

            <p class="text-muted">Click here to <a href="{{ route('getotp') }}" class="resend-sms"><u>resend</u></a> email
                after 30sec<span id="timer" class="font-weight-bold text-indigo text-lg"></span></p>
        </div>
        <div class="section mb-5 p-2">
            <form action="{{ route('codecomfirm') }}" method="post">
                @csrf
                <div class="form-group basic mb-2">

                    <input type="text" class="form-control verification-input" minlength="3" autocomplete="off"
                        name="otp" placeholder="••••" maxlength="9" required>
                </div>

                <div class="mt-3">
                    <button type="submit" class="btn btn-primary btn-block btn-lg">
                        Confirm OTP Code</button>
                </div>

            </form>
        </div>

    </div>
    <!-- * App Capsule -->



@endsection
