@extends('layouts.bankapp')
@section('title', $title)
@section('content')

    <!-- App Capsule -->
    <div id="appCapsule">

        <div class="section mt-2 mb-2">
            <x-danger-alert />
            <x-success-alert />
            <x-error-alert />
            <div class="card">
                <div class="card-body">
                    <div class="p-1">
                        <div class="text-center">
                            <h2 class="text-primary">Create a New Ticket</h2>
                            <p>Fill the form to contact us</p>
                        </div>
                        <form action="{{ route('enquiry') }}" method="post">


                            <div class="form-group basic animated">
                                <div class="input-wrapper">
                                    <label class="label" for="email2">Subject</label>
                                    <input type="text" class="form-control" name="subject" placeholder="Enter subject">
                                    <i class="clear-input">
                                        <ion-icon name="close-circle"></ion-icon>
                                    </i>
                                </div>
                            </div>

                            <div class="form-group basic animated">
                                <div class="input-wrapper">
                                    <label class="label" for="textarea2">Message</label>
                                    <textarea rows="5" name="message" class="form-control" required placeholder="Ticket Message"></textarea>
                                    <i class="clear-input">
                                        <ion-icon name="close-circle"></ion-icon>
                                    </i>
                                </div>
                            </div>
                            <input type="hidden" name="_token" value="{{ csrf_token() }}">
                            <div class="mt-2">
                                <button type="submit" class="btn btn-primary btn-lg btn-block" name="ticket-submit">Create
                                    New Ticket</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
