@extends('layouts.bankapp')
@section('title', $title)
@section('content')
    <div class="appHeader">
        <div class="left">
            <a href="{{ route('dashboard') }}" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            Transaction Detail
        </div>

    </div>

    <!-- App Capsule -->
    <div id="appCapsule" class="full-height">

        <div class="section mt-2 mb-2">


            <div class="listed-detail mt-3">
                <div class="icon-wrapper">
                    <div class="iconbox">
                        <ion-icon name="arrow-forward-outline"></ion-icon>
                    </div>
                </div>
                <h3 class="text-center mt-2">Payment</h3>
            </div>

            <ul class="listview flush transparent simple-listview no-space mt-3">
                <li>
                    <strong>Date</strong>
                    {{ \Carbon\Carbon::parse($transaction->created_at)->toDayDateTimeString() }}
                </li>

                <li>
                    <strong>Method</strong>
                    {{ $transaction->payment_mode }}
                </li>
                <li>
                    <strong>Status</strong>
                    @if ($transaction->status == 'Pending')
                        <span class="badge badge-pill badge-warning badge-sm">{{ $transaction->status }}</span>
                    @elseif($transaction->status == 'On-hold')
                        <span class="badge badge-pill badge-warning badge-sm">{{ $transaction->status }}</span>
                    @elseif($transaction->status == 'Rejected')
                        <span class="badge badge-pill badge-danger badge-sm">{{ $transaction->status }}</span>
                    @elseif($transaction->status == 'Processed')
                        <span class="badge badge-pill badge-success badge-sm">{{ $transaction->status }}</span>
                    @else
                        <span class="badge badge-pill badge-danger badge-sm">{{ $transaction->status }}</span>
                    @endif
                </li>
                <li>
                    <strong>Transaction ID</strong>
                    <span>{{ $transaction->txn_id }}</span>
                </li>
                @if ($transaction->payment_mode == 'Wire Transfer')
                    <li>
                        <strong>Account Number</strong>
                        <span>{{ $transaction->accountnumber }}</span>
                    </li>
                    <li>
                        <strong>Account Name</strong>
                        <span> {{ $transaction->accountname }}</span>
                    </li>
                @elseif ($transaction->payment_mode == 'Western Union')
                    <li>
                        <strong>Account Name</strong>
                        <span> {{ $transaction->accountname }}</span>
                    </li>

                    <li>
                        <strong>Country</strong>
                        <span>{{ $transaction->country }}</span>
                    </li>

                    <li>
                        <strong>City</strong>
                        <span>{{ $transaction->city }}</span>
                    </li>
                    <li>
                        <strong>Zipcode</strong>
                        <span>{{ $transaction->zipcode }}</span>
                    </li>
                @elseif ($transaction->payment_mode == 'Cryptocurrency')
                    <li>
                        <strong>Wallet Address</strong>
                        <span>{{ $transaction->accountnumber }}</span>
                    </li>
                @else
                    <li>
                        <strong>Email</strong>
                        <span>{{ $transaction->accountnumber }}</span>
                    </li>
                @endif
                <li>
                    <strong>Transaction Type</strong>
                    @if ($transaction->type == 'Credit')
                        <h3 class="text-success">Credit</h3>
                    @else
                        <h3 class="text-danger">Debit</h3>
                    @endif
                </li>
                <li>
                    <strong>Amount</strong>
                    <h3 class="m-0">
                        @if ($transaction->type == 'Credit')
                            <span class="text-success">

                                {{ Auth::user()->currency }}{{ number_format($transaction->amount, 2, '.', ',') }}
                            </span>
                        @else
                            <span class="text-danger">

                                {{ Auth::user()->currency }}{{ number_format($transaction->amount, 2, '.', ',') }}
                            </span>
                        @endif
                    </h3>
                </li>

                <li>
                    <strong>Description</strong>
                    <span>{{ $transaction->Description }}</span>
                </li>

            </ul>


        </div>

    </div>
    <!-- * App Capsule -->

@endsection
