<!doctype html>
<html lang="en">


<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="csrf_token" content="<?php echo e(csrf_token()); ?>" id="csrf_token" data-turbolinks-permanent>
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#000000">
    <title><?php echo e($settings->site_name); ?> | <?php echo $__env->yieldContent('title'); ?></title>
    <meta name="description" content="<?php echo e($settings->site_name); ?> ">
    <meta name="keywords" content="" />
    <link rel="icon" type="image/png" href="<?php echo e(asset('storage/app/public/' . $settings->favicon)); ?>" sizes="32x32">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('storage/app/public/' . $settings->favicon)); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" />
    <link href="<?php echo e(asset('dash2/app/fontawesome.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('dash2/app/assets/panel/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('dash2/app/assets/css/style.css')); ?>">

    <link rel="manifest" href="<?php echo e(asset('dash2/app/__manifest.json')); ?>">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>

    <script src="https://code.jquery.com/jquery-3.6.1.min.js"></script>
</head>

<body>


    <!-- App Header -->
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="#" class="headerButton" data-bs-toggle="modal" data-bs-target="#sidebarPanel">
                <ion-icon name="menu-outline"></ion-icon>
            </a>
        </div>
        <img src="<?php echo e(asset('storage/app/public/' . $settings->logo)); ?>" alt="logo" class="logo"
            style=" width: 180px; height:40px;">
        <div class="pageTitle">

        </div>
        <div class="right">

        </div>
    </div>
    <!-- * App Header -->

    <?php echo $__env->yieldContent('content'); ?>

    <div class="appBottomMenu">
        <a href="<?php echo e(route('dashboard')); ?>" class="item ">
            <div class="col">
                <ion-icon name="pie-chart-outline"></ion-icon>
                <strong>Dashboard</strong>
            </div>
        </a>
        <a href="<?php echo e(route('accounthistory')); ?>" class="item">
            <div class="col">
                <ion-icon name="document-text-outline"></ion-icon>
                <strong>Transactions</strong>
            </div>
        </a>

        <a href="<?php echo e(route('card')); ?>" class="item">
            <div class="col">
                <ion-icon name="card-outline"></ion-icon>
                <strong>My Cards</strong>
            </div>
        </a>




        <a href="<?php echo e(route('profile')); ?>" class="item">
            <div class="col">
                <ion-icon name="settings-outline"></ion-icon>
                <strong>Profile</strong>
            </div>
        </a>
    </div>
    <!-- * App Bottom Menu -->

    <?php if(Session::has('success')): ?>
        <div class="modal fade dialogbox" id="success" data-bs-backdrop="static" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">

                    <div class="modal-icon text-success">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <div class="modal-header">
                        <h5 class="modal-title">Success</h5>
                    </div>
                    <div class="modal-body ">
                        <?php echo e(Session::get('success')); ?>

                    </div>
                    <div class="modal-footer">
                        <div class="btn-inline">
                            <a href="#" class="btn btn-text-secondary" data-bs-dismiss="modal">CLOSE</a>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>




    <?php if(Session::has('message')): ?>
        <div class="modal fade dialogbox" id="error" data-bs-backdrop="static" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">

                    <div class="modal-icon text-success">
                        <i class="fas fa-times-circle"></i>
                    </div>
                    <div class="modal-header">
                        <h5 class="modal-title">Error</h5>
                    </div>
                    <div class="modal-body ">
                        <?php echo e(Session::get('message')); ?>

                    </div>
                    <div class="modal-footer">
                        <div class="btn-inline">
                            <a href="#" class="btn btn-text-secondary" data-bs-dismiss="modal">CLOSE</a>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>




    <!-- App Sidebar -->
    <div class="modal fade panelbox panelbox-left" id="sidebarPanel" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body p-0">
                    <!-- profile box -->
                    <div class="profileBox pt-2 pb-2">
                        <!-- <div class="image-wrapper">
                            <img src="assets/img/sample/avatar/avatar1.jpg" alt="image" class="imaged  w36">
                        </div> -->
                        <div class="in">





                            <strong>
                                <h2> <span style="color:#013220;"></span></h2>
                            </strong>

                            <strong><span style="color:#013220;"> Account Number:
                                    <?php echo e(Auth::user()->usernumber); ?></span>
                                <h2>
                            </strong></h2>

                            <strong><?php echo e(Auth::user()->accounttype); ?></strong>

                            <div class="text-muted"><span style="color:#013220;"><?php echo e(Auth::user()->email); ?></span>
                            </div>
                        </div>
                        <a href="#" class="btn btn-link btn-icon sidebar-close" data-bs-dismiss="modal">
                            <ion-icon name="close-outline"></ion-icon>
                        </a>
                    </div>
                    <!-- * profile box -->
                    <!-- balance -->
                    <div class="sidebar-balance">
                        <div class="listview-title">Balance</div>
                        <div class="in">
                            <h1 class="amount"><?php echo e($settings->currency); ?>

                                <?php echo e(number_format(Auth::user()->account_bal, 2, '.', ',')); ?></h1>
                        </div>
                    </div>
                    <!-- * balance -->

                    <!-- action group -->
                    <div class="action-group">
                        <a href="#" class="action-button" data-bs-toggle="modal"
                            data-bs-target="#depositActionSheet">
                            <div class="in">
                                <div class="iconbox">
                                    <ion-icon name="add-outline"></ion-icon>
                                </div>
                                Deposit
                            </div>
                        </a>
                        <a href="<?php echo e(route('loan')); ?>" class="action-button">
                            <div class="in">
                                <div class="iconbox">
                                    <ion-icon name="arrow-down-outline"></ion-icon>
                                </div>
                                Request Loan
                            </div>
                        </a>


                    </div>
                    <!-- * action group -->

                    <!-- menu -->
                    <div class="listview-title mt-1">Menu</div>
                    <ul class="listview flush transparent no-line image-listview">
                        <li>
                            <a href="<?php echo e(route('dashboard')); ?>" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="pie-chart-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Dashboard
                                    <span class="badge badge-primary"></span>
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('accounthistory')); ?>" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="document-text-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    transactions
                                </div>
                            </a>
                        </li>



                    </ul>
                    <!-- * menu -->

                    <!-- others -->
                    <div class="listview-title mt-1">Others</div>
                    <ul class="listview flush transparent no-line image-listview">
                        <li>
                            <a href="<?php echo e(route('profile')); ?>" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="settings-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Profile
                                </div>
                            </a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('logout')); ?>" class="item"
                                onclick="event.preventDefault();
                document.getElementById('logout-form').submit();">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="log-out-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Log out
                                </div>

                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST"
                                    style="display: none;">
                                    <?php echo e(csrf_field()); ?>

                                </form>
                            </a>

                        </li>


                    </ul>
                    <!-- * others -->


                </div>
            </div>
        </div>
    </div>
    <!-- * App Sidebar -->









    <!-- ========= JS Files =========  -->
    <!-- Bootstrap -->
    <script src="<?php echo e(asset('dash2/app/assets/js/lib/bootstrap.bundle.min.js')); ?>"></script>
    <!-- Ionicons -->
    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
    <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
    <!-- Splide -->
    <script src="<?php echo e(asset('dash2/app/assets/js/plugins/splide/splide.min.js')); ?>"></script>
    <!-- Base Js File -->


    <script src="<?php echo e(asset('themes/app/assets/panel/js/main.js')); ?>"></script>
    <!-- ========= JS Files =========  -->
    <!-- Bootstrap -->
    <script src="<?php echo e(asset('themes/app/assets/panel/js/lib/bootstrap.bundle.min.js')); ?>"></script>
    <!-- Ionicons -->
    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js') }}"></script>
    <!-- Splide -->
    <script src="<?php echo e(asset('themes/app/assets/panel/js/plugins/splide/splide.min.js')); ?>"></script>
    <!-- Base Js File -->
    <script src="<?php echo e(asset('themes/app/assets/panel/js/base.js')); ?>"></script>


    <script>
        $(document).ready(function() {
            $('#success').modal('show');
        });
    </script>


    <script>
        $(document).ready(function() {
            $('#error').modal('show');
        });
    </script>

</body>

<script>
    document.getElementById('selectOption').addEventListener('change', function() {
        var selectedOption = this.options[this.selectedIndex];
        var selectedValue = selectedOption.value;
        var selectedDescription = selectedOption.dataset.description;
        document.getElementById('inputField').value = selectedDescription;
        document.getElementById('descriptionField').value = selectedDescription;
    });
</script>


</html>
<?php /**PATH C:\xampp\htdocs\bankapp\resources\views/layouts/bankapp.blade.php ENDPATH**/ ?>